class Item_Tombstone extends TournamentHealth;

#exec obj load file=..\Textures\eol.utx package=eol

#exec mesh import mesh=Tombstone anivfile=Models\Tombstone_a.3d datafile=Models\Tombstone_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=Tombstone x=0 y=0 z=0
#exec mesh sequence mesh=Tombstone seq=All startframe=0 numframes=1

#exec meshmap new meshmap=Tombstone mesh=Tombstone
//#exec meshmap scale meshmap=Tombstone x=0.18750 y=0.18750 z=0.37500
#exec meshmap scale meshmap=Tombstone x=0.09375 y=0.09375 z=0.18750

var int MaxPlayerHealth;
var int LifeTime;

auto state Pickup
{	
	function Touch( actor Other )
		{
		local int HealMax;
		local Pawn P;
			
		if ( Other.IsA('Bot') || Other.IsA('PlayerPawn') ) 
			{	
			P = Pawn(Other);	

			P.Health += HealingAmount;

			if ( P.Health > MaxPlayerHealth )
				P.Health = MaxPlayerHealth;

			PlayPickupMessage(P);
			PlaySound (PickupSound,,2.5);
			Other.MakeNoise(0.2);
			Self.Destroy();
			//SetRespawn();
			}
		}
}

function PlayPickupMessage(Pawn Other)
{
	Other.ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
}

defaultproperties
{
  DrawType=DT_Mesh
  Mesh=Mesh'Tombstone'
  PickupViewMesh=Mesh'Tombstone'
  bCollideWhenPlacing=True
  bCollideActors=True
  bCollideWorld=True
  bBlockActors=True
  bBlockPlayers=True
  CollisionRadius=16.00000
  CollisionHeight=24.00000
  MultiSkins(0)=Texture'eol.estone22'
  MultiSkins(1)=Texture'Item_Tombstone'
  DrawScale=0.5
  RespawnTime=0.000000
  ScaleGlow=2.000000
  PickupMessage="You picked up a tombstone."
  PickupSound=Sound'Botpack.Pickups.UTHealth'
}
